/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.Scissors;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.VisualLogger;
import io.github.cottonmc.cotton.gui.impl.client.CottonScreenImpl;
import io.github.cottonmc.cotton.gui.impl.client.MouseInputHandler;
import io.github.cottonmc.cotton.gui.impl.client.NarrationHelper;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class CottonClientScreen
extends class_437
implements CottonScreenImpl {
    protected GuiDescription description;
    protected int left = 0;
    protected int top = 0;
    protected int titleX;
    protected int titleY;
    @Nullable
    protected WWidget lastResponder = null;
    private final MouseInputHandler<CottonClientScreen> mouseInputHandler = new MouseInputHandler<CottonClientScreen>(this);

    public CottonClientScreen(GuiDescription description) {
        this((class_2561)new class_2585(""), description);
    }

    public CottonClientScreen(class_2561 title, GuiDescription description) {
        super(title);
        this.description = description;
        description.getRootPanel().validate(description);
    }

    @Override
    public GuiDescription getDescription() {
        return this.description;
    }

    public void method_25426() {
        super.method_25426();
        this.field_22787.field_1774.method_1462(true);
        WPanel root = this.description.getRootPanel();
        if (root != null) {
            root.addPainters();
        }
        this.description.addPainters();
        this.reposition(this.field_22789, this.field_22790);
    }

    public void method_25432() {
        super.method_25432();
        this.field_22787.field_1774.method_1462(false);
        VisualLogger.reset();
    }

    @Override
    @Nullable
    public WWidget getLastResponder() {
        return this.lastResponder;
    }

    @Override
    public void setLastResponder(@Nullable WWidget lastResponder) {
        this.lastResponder = lastResponder;
    }

    protected void reposition(int screenWidth, int screenHeight) {
        WPanel root;
        if (this.description != null && (root = this.description.getRootPanel()) != null) {
            this.titleX = this.description.getTitlePos().x();
            this.titleY = this.description.getTitlePos().y();
            if (!this.description.isFullscreen()) {
                this.left = (screenWidth - root.getWidth()) / 2;
                this.top = (screenHeight - root.getHeight()) / 2;
            } else {
                this.left = 0;
                this.top = 0;
                root.setSize(screenWidth, screenHeight);
            }
        }
    }

    private void paint(class_4587 matrices, int mouseX, int mouseY) {
        this.method_25420(matrices);
        if (this.description != null) {
            WPanel root = this.description.getRootPanel();
            if (root != null) {
                GL11.glEnable((int)3089);
                Scissors.refreshScissors();
                root.paint(matrices, this.left, this.top, mouseX - this.left, mouseY - this.top);
                GL11.glDisable((int)3089);
                Scissors.checkStackIsEmpty();
            }
            if (this.method_25440() != null && this.description.isTitleVisible()) {
                int width = this.description.getRootPanel().getWidth();
                ScreenDrawing.drawString(matrices, this.method_25440().method_30937(), this.description.getTitleAlignment(), this.left + this.titleX, this.top + this.titleY, width - this.titleX, this.description.getTitleColor());
            }
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float partialTicks) {
        WWidget hitChild;
        WPanel root;
        this.paint(matrices, mouseX, mouseY);
        super.method_25394(matrices, mouseX, mouseY, partialTicks);
        if (this.description != null && (root = this.description.getRootPanel()) != null && (hitChild = root.hit(mouseX - this.left, mouseY - this.top)) != null) {
            hitChild.renderTooltip(matrices, this.left, this.top, mouseX - this.left, mouseY - this.top);
        }
        VisualLogger.render(matrices);
    }

    public void method_25393() {
        WPanel root;
        super.method_25393();
        if (this.description != null && (root = this.description.getRootPanel()) != null) {
            root.tick();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.description.getRootPanel() == null) {
            return super.method_25402(mouseX, mouseY, mouseButton);
        }
        WWidget focus = this.description.getFocus();
        if (focus != null) {
            int wx = focus.getAbsoluteX();
            int wy = focus.getAbsoluteY();
            if (!(mouseX >= (double)wx && mouseX < (double)(wx + focus.getWidth()) && mouseY >= (double)wy && mouseY < (double)(wy + focus.getHeight()))) {
                this.description.releaseFocus(focus);
            }
        }
        super.method_25402(mouseX, mouseY, mouseButton);
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        if (containerX < 0 || containerY < 0 || containerX >= this.field_22789 || containerY >= this.field_22790) {
            return true;
        }
        this.mouseInputHandler.onMouseDown(containerX, containerY, mouseButton);
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        if (this.description.getRootPanel() == null) {
            return super.method_25406(mouseX, mouseY, mouseButton);
        }
        super.method_25406(mouseX, mouseY, mouseButton);
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseUp(containerX, containerY, mouseButton);
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        if (this.description.getRootPanel() == null) {
            return super.method_25403(mouseX, mouseY, mouseButton, deltaX, deltaY);
        }
        super.method_25403(mouseX, mouseY, mouseButton, deltaX, deltaY);
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseDrag(containerX, containerY, mouseButton, deltaX, deltaY);
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.description.getRootPanel() == null) {
            return super.method_25401(mouseX, mouseY, amount);
        }
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseScroll(containerX, containerY, amount);
        return true;
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.description.getRootPanel() == null) {
            return;
        }
        int containerX = (int)mouseX - this.left;
        int containerY = (int)mouseY - this.top;
        this.mouseInputHandler.onMouseMove(containerX, containerY);
    }

    public boolean method_25400(char ch, int keyCode) {
        if (this.description.getFocus() == null) {
            return false;
        }
        this.description.getFocus().onCharTyped(ch);
        return true;
    }

    public boolean method_25404(int ch, int keyCode, int modifiers) {
        if (super.method_25404(ch, keyCode, modifiers)) {
            return true;
        }
        if (this.description.getFocus() == null) {
            return false;
        }
        this.description.getFocus().onKeyPressed(ch, keyCode, modifiers);
        return true;
    }

    public boolean method_16803(int ch, int keyCode, int modifiers) {
        if (this.description.getFocus() == null) {
            return false;
        }
        this.description.getFocus().onKeyReleased(ch, keyCode, modifiers);
        return true;
    }

    @Override
    public void renderTextHover(class_4587 matrices, @Nullable class_2583 textStyle, int x, int y) {
        this.method_25418(matrices, textStyle, x, y);
    }

    public boolean method_25407(boolean lookForwards) {
        if (this.description != null) {
            this.description.cycleFocus(lookForwards);
        }
        return true;
    }

    protected void method_37056(class_6382 builder) {
        if (this.description != null) {
            NarrationHelper.addNarrations(this.description.getRootPanel(), builder);
        }
    }
}

